import os
import logging.config
import subprocess

import tornado.process
from tornado.ioloop import IOLoop
from tornado.options import define, options
from tornado.web import Application, RequestHandler

from travel.avia.aeroflot_queue_proxy import settings

logger = logging.getLogger()

define('debug', default=False, help='Debug mode')


class PingHandler(RequestHandler):
    def get(self):
        result = subprocess.check_output(['supervisorctl', 'status', 'consumer'])
        self.set_header('Content-Type', 'text/plain')
        self.set_status(200 if result.count(b'\n') == result.count(b'RUNNING') else 500)
        self.write(result)


class VersionHandler(RequestHandler):
    def get(self):
        self.set_header('Content-Type', 'text/plain')
        self.write('Tornado version: {}\n'.format(tornado.version))
        self.write('Package tag: {}\n'.format(os.getenv('DEPLOY_DOCKER_IMAGE')))
        self.write('Package hash: {}\n'.format(os.getenv('DEPLOY_DOCKER_HASH')))


def create_application(debug=False):
    return Application(
        [
            (r'/ping', PingHandler),
            (r'/version', VersionHandler),
        ],
        debug=debug,
    )


def main():
    settings.setup_logging()
    application = create_application(debug=options.debug)
    application.listen(settings.API_LISTEN_PORT)
    IOLoop.current().start()


if __name__ == '__main__':
    options.parse_command_line()
    logger.info('Tornado version: {}'.format(tornado.version))
    logger.info('Debug: {}'.format(options.debug))
    main()
