import logging
import time

import ujson

from travel.avia.aeroflot_queue_proxy.lib.yt_loggers.yt_log import validate_schema

aeroflot_queue_order_message_yt_logger = logging.getLogger('yt.orders.aeroflot_queue_order_message')
log = logging.getLogger(__name__)


aeroflot_queue_order_message_log_schema = dict(
    unixtime=dict(type=int, lf_type='VT_UINT64', required=True),
    raw_message=dict(type=str, lf_type='VT_STRING', required=True),
    marker=dict(type=str, lf_type='VT_STRING', required=True),
)


async def log_aeroflot_queue_order_message(message, marker):
    """
    :param message: raw message xml
    :param marker: marker extracted from the message
    """

    log_entry = {
        'raw_message': message,
        'marker': marker,
        'unixtime': int(time.time()),
    }

    try:
        await validate_schema(log_entry, aeroflot_queue_order_message_log_schema)
        aeroflot_queue_order_message_yt_logger.info('%s', ujson.dumps(log_entry))
    except (KeyError, ValueError, TypeError) as e:
        log.exception('Cannot log data %s. %s', log_entry, e)
