import os
import sys
import logging.config

IBM_MQ_HOST = os.getenv('AVIA_IBM_MQ_HOST', None)
IBM_MQ_QUEUE_MANAGER = os.getenv('AVIA_IBM_MQ_QUEUE_MANAGER', 'QMSUIXCERT')
IBM_MQ_CHANNEL = os.getenv('AVIA_IBM_MQ_CHANNEL', 'YANDEX.SVRCONN')
IBM_MQ_QUEUE_NAME = os.getenv('AVIA_IBM_MQ_QUEUE_NAME', 'IX.YANDEX.SBAGENTLOG.OUT')

SQS_ENDPOINT = os.getenv('AVIA_SQS_ENDPOINT', 'http://sqs.yandex.net:8771')
SQS_ACCOUNT = os.getenv('AVIA_SQS_ACCOUNT', 'avia')
SQS_AEROFLOT_QUEUE_NAME = os.getenv('AVIA_SQS_AEROFLOT_QUEUE_NAME')
SQS_AEROFLOT_BOY_QUEUE_NAME = os.getenv('AVIA_SQS_AEROFLOT_BOY_QUEUE_NAME')
SQS_AEROFLOT_CPA_QUEUE_NAME = os.getenv('AVIA_SQS_AEROFLOT_CPA_QUEUE_NAME')

markers_str = os.getenv('AVIA_AEROFLOT_BOY_MARKERS_LIST', '')
AEROFLOT_BOY_MARKERS_LIST = markers_str.split(',') if markers_str else []

API_LISTEN_PORT = os.getenv('AVIA_API_LISTEN_PORT', 80)


def setup_logging():
    if os.getenv('DEPLOY_UNIT_ID') is not None:
        logging.config.dictConfig({
            'version': 1,
            'disable_existing_loggers': False,
            'loggers': {
                '__main__': {
                    'handlers': ['deploy', 'sentry'],
                    'level': 'INFO',
                },
                'yt.orders.aeroflot_queue_order_message': {
                    'handlers': ['lb'],
                    'level': 'INFO',
                }
            },
            'formatters': {
                'json': {
                    '()': 'cloud_logger.formatters.DeployJsonFormatter',
                    'format': '%(name)s: %(message)s',
                    'datefmt': '%Y-%m-%d %H:%M:%S',
                },
            },
            'handlers': {
                'lb': {
                    'level': 'INFO',
                    'filename': '{}/yt/orders/aeroflot_queue_order_message.log'.format(os.getenv('AVIA_LOG_PATH')),
                    'mode': 'a',
                    'class': 'logging.FileHandler',
                },
                'deploy': {
                    'level': 'INFO',
                    'class': 'logging.StreamHandler',
                    'stream': sys.stdout,
                    'formatter': 'json',
                },
                'sentry': {
                    'level': 'ERROR',
                    'class': 'raven.handlers.logging.SentryHandler',
                    'dsn': os.getenv('AVIA_SENTRY_URL'),
                },
            },
        })
    else:
        LOG_LEVEL = os.getenv('AVIA_LOG_LEVEL', logging.INFO)

        root = logging.getLogger()
        root.setLevel(LOG_LEVEL)
        handler = logging.StreamHandler(sys.stdout)
        handler.setLevel(LOG_LEVEL)
        handler.setFormatter(
            logging.Formatter('%(name)s: %(levelname)s %(asctime)s %(message)s'),
        )
        root.addHandler(handler)
