class AnswerCalculator(object):
    def __init__(self, time_column='unixtime', threhold=1, price_column='original_price', answer_column='answer'):
        self.time_column = time_column
        self.threhold = threhold
        self.price_column = price_column
        self.answer_column = answer_column

    def __call__(self, key, records):
        records = list(records)
        for i in range(len(records) - 1):
            assert records[i][self.time_column] <= records[i + 1][self.time_column]
        for ind, record in enumerate(records):
            current_price = record[self.price_column]
            for future_record in records[ind + 1:]:
                if abs(future_record[self.price_column] - current_price) > self.threhold:
                    record[self.answer_column] = future_record[self.time_column] - record[self.time_column]
                    break

            yield record
