from travel.avia.library.python.shared_dicts.cache.station_code_cache import StationCodeCache
from travel.avia.library.python.shared_dicts.cache.station_cache import StationCache
from travel.avia.library.python.shared_dicts.cache.settlement_cache import SettlementCache
from travel.avia.library.python.shared_dicts.cache.station_to_settlement_cache import StationToSettlementCache
from travel.avia.library.python.shared_dicts.cache.region_cache import RegionCache
from travel.avia.library.python.shared_dicts.cache.country_cache import CountryCache
from travel.avia.library.python.shared_dicts.cache.company_cache import CompanyCache
from travel.avia.library.python.shared_dicts.cache.timezone_cache import TimezoneCache
from travel.avia.library.python.shared_dicts.cache.fare_family_cache import FareFamilyCache
from travel.avia.library.python.shared_dicts.cache.transport_model_cache import TransportModelCache

from travel.avia.api_gateway.application.cache.landing_routes_cache import LandingRoutesCache
from travel.avia.api_gateway.application.cache.tanker_text_cache import (
    CityToLandingTextCache,
    RouteLandingTextCache,
    FlightLandingTextCache,
)


class CacheRoot:
    """
    Contains all caches, and has no logic of its own.
    """

    def __init__(
        self,
        station_code_cache: StationCodeCache,
        settlement_cache: SettlementCache,
        station_to_settlement_cache: StationToSettlementCache,
        company_cache: CompanyCache,
        city_to_landing_text_cache: CityToLandingTextCache,
        route_landing_text_cache: RouteLandingTextCache,
        station_cache: StationCache,
        flight_landing_text_cache: FlightLandingTextCache,
        region_cache: RegionCache,
        country_cache: CountryCache,
        timezone_cache: TimezoneCache,
        fare_family_cache: FareFamilyCache,
        transport_model_cache: TransportModelCache,
        landing_routes_cache: LandingRoutesCache,
    ):
        self.station_code_cache = station_code_cache
        self.settlement_cache = settlement_cache
        self.station_to_settlement_cache = station_to_settlement_cache
        self.company_cache = company_cache
        self.city_to_landing_text_cache = city_to_landing_text_cache
        self.flight_landing_text_cache = flight_landing_text_cache
        self.route_landing_text_cache = route_landing_text_cache
        self.station_cache = station_cache
        self.region_cache = region_cache
        self.country_cache = country_cache
        self.timezone_cache = timezone_cache
        self.fare_family_cache = fare_family_cache
        self.transport_model_cache = transport_model_cache
        self.landing_routes_cache = landing_routes_cache
