import json

import pathlib2

from travel.avia.api_gateway.lib.landings.tanker_text_cache import TankerTextCache
from travel.avia.api_gateway.settings import TANKER_CACHE_PATH


class TankerTextFileCache(TankerTextCache):
    def __init__(self, *args, **kwargs):
        super(TankerTextFileCache, self).__init__(*args, **kwargs)

        cache_directory = pathlib2.Path(TANKER_CACHE_PATH)
        cache_directory.mkdir(parents=True, exist_ok=True)
        self._cache_file_name = cache_directory.joinpath(self.KEYSET_ID).as_posix()

    def populate(self):
        try:
            super(TankerTextFileCache, self).populate()
        except Exception as e:
            self.logger.error('Failed to download keyset %s: %s. Will try to read from file cache', self.KEYSET_ID, e)
            self.keyset = self.read_from_file()
            self.logger.info('populated cache from file with %d keys', len(self.keyset))

    def download_keyset(self):
        keyset = super(TankerTextFileCache, self).download_keyset()
        self.store_to_file(keyset)
        return keyset

    def store_to_file(self, keyset):
        with open(self._cache_file_name, 'w') as f:
            json.dump(keyset, f)

    def read_from_file(self):
        with open(self._cache_file_name) as f:
            return json.load(f)


class CityToLandingTextCache(TankerTextFileCache):
    KEYSET_ID = 'avia.city-landing'


class RouteLandingTextCache(TankerTextFileCache):
    KEYSET_ID = 'avia.route-landing'


class FlightLandingTextCache(TankerTextFileCache):
    KEYSET_ID = 'avia.flight-landing'
