# -*- encoding: utf-8 -*-
import logging
import memcache

from travel.avia.api_gateway.settings import MEMCACHED_HOST

logger = logging.getLogger(__name__)


class AnywhereLandingCache:
    _client = None
    settlement_images_key = 'settlement_images_{}'
    all_settlement_images_key = 'all_settlement_images'
    country_restrictions_key = 'country_restrictions_from_{}'

    @classmethod
    def client(cls):
        # type: () -> memcache.Client
        if not cls._client:
            cls._client = memcache.Client([MEMCACHED_HOST])

        return cls._client

    @classmethod
    def _get_settlement_images_key(cls, settlement_id):
        # type: (int) -> str
        return cls.settlement_images_key.format(settlement_id)

    @classmethod
    def _get_country_restrictions_key(cls, from_settlement_id):
        # type: (int) -> str
        return cls.country_restrictions_key.format(from_settlement_id)

    @classmethod
    def get_images_for_settlement(cls, settlement_id):
        # type: (int) -> dict[str, str]
        return cls.client().get(cls._get_settlement_images_key(settlement_id))

    @classmethod
    def set_images_for_settlement(cls, settlement_id, images):
        # type: (int, dict[str, str]) -> None
        return cls.client().set(cls._get_settlement_images_key(settlement_id), images)

    @classmethod
    def get_images_for_all_settlements(cls):
        # type: () -> dict[str, dict]
        return cls.client().get(cls.all_settlement_images_key)

    @classmethod
    def set_images_for_all_settlements(cls, images):
        # type: (dict[str, dict]) -> None
        return cls.client().set(cls.all_settlement_images_key, images)

    @classmethod
    def get_country_restrictions(cls, from_settlement_id):
        # type: (int) -> dict[str, str]
        return cls.client().get(cls._get_country_restrictions_key(from_settlement_id))

    @classmethod
    def set_country_restrictions(cls, from_settlement_id, country_restrictions):
        # type: (int, dict[str, str]) -> None
        return cls.client().set(
            cls._get_country_restrictions_key(from_settlement_id),
            country_restrictions,
        )
