# -*- encoding: utf-8 -*-
from typing import List

import tornado.escape
from tornado.httpclient import HTTPResponse

from travel.avia.api_gateway.application.fetcher import Fetcher
from travel.avia.api_gateway.settings import AVIA_STATISTICS_API_URL


class CityToLandingDataFetcher(Fetcher):
    def fetch(self, fetchers: list[Fetcher] = None):
        to_id = self.params.get('to_id')
        national_version = self.params.get('national_version')
        self.request(
            '{}/landing/city-to/'.format(AVIA_STATISTICS_API_URL),
            params={
                'toId': to_id,
                'nationalVersion': national_version,
            },
            callback=self.on_response,
        )

    def on_response(self, response):
        # type: (HTTPResponse) -> None
        landing = tornado.escape.json_decode(response.body)['result']
        self.finish_callback(landing, field=self.field)


class CountrySearchPopularCitiesFetcher(Fetcher):
    def fetch(self, fetchers: list[Fetcher] = None):
        country_id = self.params.get('country_id')
        self.request(
            '{}/country_search/popular_cities_desc'.format(AVIA_STATISTICS_API_URL),
            params={
                'country_id': country_id,
            },
            callback=self.on_response,
        )

    def on_response(self, response: HTTPResponse):
        popular_cities = tornado.escape.json_decode(response.body)['cities']
        self.finish_callback(popular_cities, field=self.field)


class RouteLandingDataFetcher(Fetcher):
    def fetch(self, fetchers=None):  # type: (List[Fetcher]) -> None
        from_id = self.params.get('from_id')
        to_id = self.params.get('to_id')
        national_version = self.params.get('national_version')
        self.request(
            '{}/landing/route/'.format(AVIA_STATISTICS_API_URL),
            params={
                'fromId': from_id,
                'toId': to_id,
                'nationalVersion': national_version,
            },
            callback=self.on_response,
        )

    def on_response(self, response):
        # type: (HTTPResponse) -> None
        landing = tornado.escape.json_decode(response.body)['result']
        self.finish_callback(landing, field=self.field)


class LandingRoutesFetcher(Fetcher):
    def fetch(self, fetchers=None):  # type: (List[Fetcher]) -> None
        self.request('{}/landing/all_routes/'.format(AVIA_STATISTICS_API_URL), callback=self.on_response)

    def fetch_sync(self):
        response = self.request_sync('{}/landing/all_routes/'.format(AVIA_STATISTICS_API_URL))
        return tornado.escape.json_decode(response.body)

    def on_response(self, response):
        # type: (HTTPResponse) -> None
        landing = tornado.escape.json_decode(response.body)
        self.finish_callback(landing, field=self.field)
