from typing import Union, Optional
import enum

from pydantic import BaseModel, Field, HttpUrl, PositiveInt

from travel.avia.library.python.enum import Currency

GeoID = int

SettlementKey = str  # c52
StationKey = str  # s18352
CountryKey = str  # l65


class EKlass(str, enum.Enum):
    economy = 'economy'
    business = 'business'


class Linguistics(BaseModel):
    ablative_case: str = Field('', alias='ablativeCase')  # '',
    accusative_case: str = Field('', alias='accusativeCase')  # 'Москву',
    dative_case: str = Field('', alias='dativeCase')  # 'Москве',
    directional_case: str = Field('', alias='directionalCase')  # '',
    genitive_case: str = Field('', alias='genitiveCase')  # 'Москвы',
    instrumental_case: str = Field('', alias='instrumentalCase')  # 'Москвой',
    locative_case: str = Field('', alias='locativeCase')  # '',
    nominative_case: str = Field('', alias='nominativeCase')  # 'Москва',
    preposition: str = ''  # 'в',
    prepositional_case: str = Field('', alias='prepositionalCase')  # 'Москве',

    class Config:
        allow_population_by_field_name = True


class Image(BaseModel):
    height: PositiveInt
    width: PositiveInt
    url: HttpUrl


class PriceWithExpiration(BaseModel):
    expired: bool
    value: Union[int, str]
    """Обычно если число, то целочисленная величина; если строка, то чётко отформатированный decimal."""
    currency: Currency


class SettlementInfo(BaseModel):
    key: SettlementKey  # c213
    title: Linguistics
    images: list[
        list[Image]
    ]  # Массив массивов изображений. То есть images[0] содержит массив с разными размерами первого изображения
    price: Optional[PriceWithExpiration]
    country_restrictions: Optional[dict]
    geo_data: Optional[dict]

    class Config:
        allow_population_by_field_name = True


class FromPoint(BaseModel):
    key: Union[SettlementKey, StationKey]
    title: Linguistics


class ToCountry(BaseModel):
    id: GeoID
    key: CountryKey
    title: Linguistics
