# -*- encoding: utf-8 -*-
from enum import Enum


class FlightBlockType(str, Enum):
    SEARCH_FORM_BLOCK = 'searchForm'
    BREADCRUMBS_BLOCK = 'breadCrumbs'
    FLIGHT_TITLE_BLOCK = 'flightTitle'
    FLIGHT_DATES_BLOCK = 'flightDates'
    FLIGHT_BLOCK = 'flight'
    DISCLAIMER_BLOCK = 'disclaimer'
    MAP_BLOCK = 'map'
    ADDITIONAL_INFO_BLOCK = 'additionalInfo'
    TICKETS_BLOCK = 'tickets'
    USEFUL_LINKS_BLOCK = 'usefulLinks'
    FLIGHT_SEO_TEXT = 'flightSeoText'

    SECTION_TEXT_BLOCK = 'ISectionTextBlock'
    TEXT_BLOCK = 'ITextBlock'
    PLAIN_TEXT_BLOCK = 'IPlainTextBlock'
    EXTERNAL_LINK_BLOCK = 'IExternalLinkBlock'


class Color(str, Enum):
    RED = 'red'
    BLACK = 'black'
    GREY = 'grey'
    YELLOW = 'yellow'
    GREEN = 'green'


class PlainTextStyle(str, Enum):
    BOLD = 'bold'


class TermType(str, Enum):
    BAGGAGE = 'baggage'
    CARRY_ON = 'carryOn'
    CHANGING_CARRIAGE = 'changingCarriage'
    MILES = 'miles'
    REFUNDABLE = 'refundable'
    SEAT_SELECTION_CHECK_IN = 'seatSelectionCheckIn'


class Availability(str, Enum):
    FREE = 'FREE'
    CHARGE = 'CHARGE'
    NOT_AVAILABLE = 'NOT_AVAILABLE'
