# -*- encoding: utf-8 -*-
import logging
from typing import Dict, Optional
from functools import partial

from tornado.web import HTTPError

from travel.avia.api_gateway.application.fetcher import Fetcher
from travel.avia.api_gateway.application.fetcher.personal_search.mapper import PersonalSearchMapper
import travel.avia.api_gateway.application.fetcher.personalization as personalization_service

logger = logging.getLogger(__name__)


class PersonalSearchFetcher(Fetcher):
    service = 'personal_search'

    def __init__(self, personal_search_mapper, *args, **kwargs):
        # type: (PersonalSearchMapper, any, any) -> None
        super(PersonalSearchFetcher, self).__init__(*args, **kwargs)
        self._personal_search_mapper = personal_search_mapper

    def fetch(self, fetchers=None):
        geo_id = self.params.get('geo_id')
        yandex_uid = self.params.get('yandex_uid')

        if not yandex_uid:
            raise HTTPError(404, reason='yandexUid must be specified')

        fetcher = Fetcher(partial(self.on_response, geo_id))
        fetcher.fetch([personalization_service.PersonalSearchFetcher(geo_id=geo_id, yandex_uid=yandex_uid)])

    def on_response(self, geo_id, response):
        # type: (Optional[int], Dict) -> None
        mapped_response = self._personal_search_mapper.map(geo_id, response)
        self.finish_callback(mapped_response, field=self.field)
