# -*- encoding: utf-8 -*-
from typing import List

import tornado.escape
from tornado.httpclient import HTTPResponse

from travel.avia.api_gateway.application.fetcher import Fetcher
from travel.avia.api_gateway.settings import PERSONALIZATION_API_URL


class PersonalSearchFetcher(Fetcher):
    def fetch(self, fetchers=None):  # type: (List[Fetcher]) -> None
        geo_id = self.params.get('geo_id')
        yandex_uid = self.params.get('yandex_uid')
        self.request(
            '{}/personal-search'.format(PERSONALIZATION_API_URL),
            params={
                'geoId': geo_id,
                'yandexUid': yandex_uid,
            },
            callback=self.on_response,
        )

    def on_response(self, response):
        # type: (HTTPResponse) -> None
        landing = tornado.escape.json_decode(response.body)
        self.finish_callback(landing, field=self.field)
