# -*- encoding: utf-8 -*-
from typing import List

import tornado.escape
from tornado.httpclient import HTTPResponse

from travel.avia.api_gateway.application.fetcher import Fetcher
from travel.avia.api_gateway.settings import PRICE_INDEX_HOST


class BaseFetcher(Fetcher):
    PRICE_INDEX_METHOD = None

    def fetch(self, fetchers=None):  # type: (List[Fetcher]) -> None
        self.request(
            'http://{host}/search_methods/v1/{method}/{national_version}'.format(
                host=PRICE_INDEX_HOST,
                method=self.PRICE_INDEX_METHOD,
                national_version=self.params.get('national_version'),
            ),
            method='POST',
            headers={
                'Content-Type': 'application/json',
            },
            body=tornado.escape.json_encode(self.params.get('request')),
            callback=self.on_response,
        )

    def on_response(self, response):
        # type: (HTTPResponse) -> None
        self.finish_callback(
            tornado.escape.json_decode(response.body),
            field=self.field,
        )


class MinPriceBatchSearch(BaseFetcher):
    service = 'price_index_search_methods_min_price_batch_search'
    PRICE_INDEX_METHOD = 'min_price_batch_search'


class TopDirectionsByDateWindow(BaseFetcher):
    service = 'price_index_top_directions_by_date_window'
    PRICE_INDEX_METHOD = 'top_directions_by_date_window'
