# -*- encoding: utf-8 -*-
from typing import Optional

NBSP = '\xa0'


def format_travel_duration(duration_min):
    # type: (int) -> Optional[unicode]
    if duration_min is None:
        return None
    if duration_min == 0:
        return '0 мин'
    days = duration_min / 60 / 24
    hours = duration_min / 60 % 24
    minutes = duration_min % 60
    parts = []
    if days:
        parts.append('{} дн.'.format(days))
    if hours:
        parts.append('{} ч'.format(hours))
    if minutes:
        parts.append('{} мин'.format(minutes))
    return ' '.join(parts)


def get_plural_form(n, forms):
    return '%d %s' % (
        n,
        forms[
            0
            if (n % 10 == 1 and n % 100 != 11)
            else (1 if (n % 10 >= 2 and n % 10 <= 4 and (n % 100 < 10 or n % 100 >= 20)) else 2)
        ],
    )


def human_duration(minutes):
    # type: (int) -> Optional[unicode]
    if not isinstance(minutes, int):
        return None

    days = minutes // 60 // 24
    hours = (minutes // 60) % 24
    minutes = minutes % (60 * 24) % 60

    blocks = []

    if days:
        blocks.append(get_plural_form(days, ['день', 'дня', 'дней']))

    if hours:
        blocks.append(get_plural_form(hours, ['час', 'часа', 'часов']))

    if minutes:
        blocks.append(get_plural_form(minutes, ['минута', 'минуты', 'минут']))

    return ' '.join(b.replace(' ', NBSP) for b in blocks)
