# -*- encoding: utf-8 -*-
from travel.library.python.tvm_ticket_provider import AbstractTvmTicketProvider, provider_fabric

from travel.avia.api_gateway import settings


class TvmFactory(object):
    def __init__(self):
        self._tvm_provider = None

    def get_provider(self):
        # type: () -> AbstractTvmTicketProvider
        if settings.AVIA_API_GATEWAY_TVM_ID and not self._tvm_provider:
            self._tvm_provider = provider_fabric.create(
                source_id=settings.AVIA_API_GATEWAY_TVM_ID,
                destinations=[settings.TRAVEL_API_TVM_ID],
                fake=settings.TVM_FAKE,
                secret=settings.AVIA_API_GATEWAY_TVM_SECRET,
            )
        return self._tvm_provider


tvm_factory = TvmFactory()
