# -*- encoding: utf-8 -*-
import logging
import os
import time
from logging.handlers import WatchedFileHandler

from tornado.httpserver import HTTPRequest

from travel.avia.api_gateway.settings import YT_REQUEST_LOG, YT_RESPONSE_LOG
from travel.avia.api_gateway.lib.json import json_encode


def yt_request_log(handler, request):
    # type: (str, HTTPRequest) -> None
    if not yt_request_log.logger.handlers:
        yt_request_log.logger.addHandler(WatchedFileHandler(YT_REQUEST_LOG.format(pid=os.getpid())))

    log_event = {
        'unixtime': int(time.time()),
        'handler': handler,
        'method': request.method,
        'path': request.path,
        'query': request.query_arguments,
        'body': request.body,
    }
    yt_request_log.logger.info(json_encode(log_event))


yt_request_log.logger = logging.getLogger('yt.request')
yt_request_log.logger.setLevel(logging.INFO)
yt_request_log.logger.propagate = False


def yt_response_log(request, response, request_id):
    # type: (HTTPRequest, str, str) -> None
    if not yt_response_log.logger.handlers:
        yt_response_log.logger.addHandler(WatchedFileHandler(YT_RESPONSE_LOG.format(pid=os.getpid())))

    log_event = {
        'unixtime': int(time.time()),
        'request_id': request_id,
        'method': request.method,
        'path': request.path,
        'query': request.query_arguments,
        'body': request.body,
        'response': response,
        'uri': request.uri,
        'request_time': request.request_time(),
    }
    yt_response_log.logger.info(json_encode(log_event))


yt_response_log.logger = logging.getLogger('yt.response')
yt_response_log.logger.setLevel(logging.INFO)
yt_response_log.logger.propagate = False
