# coding: utf8
from base_util import nginx_log_normalize_uri

paths = [
    (r'keys$', None),
    (r'version$', None),
    (r'airport/[^\/]+/flight/', '/airport/CODE/flight/'),
    (r'flight/[^\/]+/[^\/]+/[^\/]+/', '/flight/CODE/NUMBER/DATE/'),
    (r'flight/[^\/]+/[^\/]+/', '/flight/CODE/NUMBER/'),
    (r'flight/mail/', '/flight/mail/'),
    (r'flight/', '/flight/'),
    (r'airport/tablo-source', '/airport/tablo-source'),
    (r'price-index/search_methods/v1/search/', '/price-index/search_methods/v1/search/'),
    (r'price-index/', '/price-index/'),
    (
        r'ticket-daemon-api/jsendapi/front/init_search_by_query/',
        '/ticket-daemon-api/jsendapi/front/init_search_by_query/',
    ),
    (r'ticket-daemon-api/jsendapi/v3/results/', '/ticket-daemon-api/jsendapi/v3/results/'),
    (r'ticket-daemon-api/jsendapi/v3/order', '/ticket-daemon-api/jsendapi/v3/order'),
    (r'ticket-daemon-api/jsendapi/v3/redirect', '/ticket-daemon-api/jsendapi/v3/redirect'),
    (r'ticket-daemon-api/', '/ticket-daemon-api/'),
    (r'flight-extras/', '/flight-extras/'),
    (r'avia-api/', '/avia-api/'),
    (r'backend/', '/backend/'),
    (r'avia-features/feature-flag', '/avia-features/feature-flag'),
    (r'avia-features/', '/avia-features/'),
    (r'currency/', '/currency/'),
    (r'airlines/synonyms/', '/airlines/synonyms/'),
    (r'partners/popular-by-route/', '/partners/popular-by-route/'),
    (r'geo/point/', '/geo/point/'),
    (r'travel/recipes/', '/travel/recipes/'),
    (r'travel/near-directions/', '/travel/near-directions/'),
    (r'top-flights/', '/top-flights/'),
    (r'landing/route/[^\/]+/[^\/]+/[^\/]+/[^\/]+/', '/landing/route/FROM/TO/NATIONAL_VERSION/LANG/'),
    (r'landing/flight/[^\/]+/[^\/]+/[^\/]+/[^\/]+/', '/landing/flight/COMPANY/NUMBER/NATIONAL_VERSION/LANG/'),
    (r'is-possible-trip/[^\/]+/[^\/]+/[^\/]+/[^\/]+/', '/is-possible-trip/FROM/TO/DEPARTURE_DATE/NATIONAL_VERSION/'),
    (r'settlement-slug-by-geo-id/', '/settlement-slug-by-geo-id/'),
    (r'settlement-slugs-by-route/', '/settlement-slugs-by-route/'),
]


def nginx_log_normalize_path(uri):
    return nginx_log_normalize_uri(paths, uri)
