from dataclasses import dataclass


@dataclass
class AvatarSize:
    alias: str
    width: int
    height: int


@dataclass
class NamespaceSizes:
    namespace: str
    sizes: list[AvatarSize]


AVATARS_SIZES_CONFIG = [
    NamespaceSizes(
        namespace='avia',
        sizes=[
            AvatarSize(alias='country-desktop', width=1200, height=800),
            AvatarSize(alias='country-mobile', width=414, height=852),
            AvatarSize(alias='offer-desktop', width=595, height=300),
            AvatarSize(alias='offer-desktop-short', width=394, height=300),
            AvatarSize(alias='offer-desktop-wide', width=1200, height=320),
            AvatarSize(alias='offer-mobile-wide', width=395, height=70),
            AvatarSize(alias='offer-travel-desktop', width=386, height=340),
            AvatarSize(alias='offer-travel-desktop-ultrawide', width=1200, height=200),
            AvatarSize(alias='offer-travel-desktop-wide', width=386, height=160),
            AvatarSize(alias='offer-travel-desktop-wider', width=590, height=160),
            AvatarSize(alias='offer-travel-mobile', width=220, height=240),
            AvatarSize(alias='offer-travel-mobile-square', width=240, height=240),
            AvatarSize(alias='route-desktop', width=1200, height=450),
            AvatarSize(alias='route-mobile', width=414, height=371),
            AvatarSize(alias='travel-marketing-square', width=500, height=500),
            AvatarSize(alias='wizard-route-carousel', width=194, height=130),
        ],
    ),
    NamespaceSizes(
        namespace='rasp',
        sizes=[
            AvatarSize(alias='travel-avia-desktop', width=285, height=227),
            AvatarSize(alias='travel-avia-desktop-retina', width=570, height=454),
            AvatarSize(alias='travel-avia-touch', width=190, height=143),
            AvatarSize(alias='travel-avia-touch-retina', width=380, height=286),
        ],
    ),
]

AVATARS_SIZES_BY_NAMESPACE = {
    namespace_sizes.namespace: namespace_sizes.sizes for namespace_sizes in AVATARS_SIZES_CONFIG
}
