# -*- coding: utf-8 -*-
import logging

from travel.avia.api_gateway import settings

import feature_flag_client


_feature_flags_client = feature_flag_client.Client(
    host=settings.AVIA_FEATURES_HOST, service_code='api-gateway', logger=logging.getLogger('feature_flag_client')
)

if settings.YANDEX_ENVIRONMENT_TYPE == 'development':

    class DevelopmentClient:
        DEVELOPMENT_FLAGS = []
        if hasattr(settings, 'DEVELOPMENT_FLAGS'):
            DEVELOPMENT_FLAGS = settings.DEVELOPMENT_FLAGS

        def create_context(self):
            return feature_flag_client.Context(set(value.strip() for value in self.DEVELOPMENT_FLAGS))

    _feature_flags_client = DevelopmentClient()

feature_flags_storage = feature_flag_client.Storage(_feature_flags_client)


def enable_hotels_block_in_routes_landing():
    return feature_flags_storage.flag_enabled('API_GATEWAY_ENABLE_HOTELS_IN_ROUTES_LANDING')
