# -*- encoding: utf-8 -*-
from tornado.escape import json_encode as tornado_json_encode


def json_encode(obj):
    return tornado_json_encode(prepare_for_json(obj))


def prepare_for_json(obj):
    if isinstance(obj, dict):
        return {prepare_for_json(k): prepare_for_json(v) for k, v in obj.items()}
    if isinstance(obj, (list, tuple)):
        return tuple(prepare_for_json(v) for v in obj)
    if isinstance(obj, bytes):
        try:
            return obj.decode('utf-8')
        except AttributeError:
            return obj.decode('latin-1')
    return obj
