from logging import Logger

from travel.avia.library.python.tanker.client import TankerClient


class TankerTextCache:
    PROJECT_ID = 'travel-backend'
    KEYSET_ID = ''
    LANG = 'ru'

    def __init__(self, tanker_client, logger, branch_id):
        # type: (TankerClient, Logger, str) -> None
        self.keyset = {}
        self.tanker_client = tanker_client
        self.logger = logger
        self.branch_id = branch_id

    def get_text_by_key(self, key):
        if not key:
            return None
        if key in self.keyset:
            return self.keyset[key]
        self.logger.warning('No text for key %d in the cache', key)

    def items(self):
        return self.keyset.items()

    def clear_cache(self):
        self.keyset = {}

    def populate(self):
        self.keyset = self.download_keyset()
        self.logger.info('populated cache with %d keys', len(self.keyset))

    def update_cache(self):
        try:
            self.keyset = self.download_keyset()
        except Exception as e:
            self.logger.error(
                'Failed to update tanker text cache from keyset %s. Will continue using old cache. Reason: %s',
                self.KEYSET_ID,
                e,
            )
            return

        self.logger.info('updated with keyset of size %d', len(self.keyset))

    def download_keyset(self):
        return self.tanker_client.load_keyset(
            project_id=self.PROJECT_ID,
            keyset_id=self.KEYSET_ID,
            lang=self.LANG,
            branch_id=self.branch_id,
        )
