# -*- encoding: utf-8 -*-
import os
import logging
from logging.config import dictConfig

from cloud_logger import default_config

CURRENT_DC = os.getenv('DEPLOY_NODE_DC', None)

LOG_PATH = os.getenv('AVIA_LOG_PATH', '/var/log/yandex-avia-api-gateway')
TANKER_CACHE_PATH = os.getenv('AVIA_TANKER_CACHE_PATH', '/var/cache/tanker')

BACKEND_API_URL = os.getenv('AVIA_BACKEND_API_URL', None)
CONTENT_BACKEND_API_URL = os.getenv('TRAVEL_CONTENT_BACKEND_API_URL', None)
PERSONALIZATION_API_URL = os.getenv('AVIA_PERSONALIZATION_API_URL', None)
SHARED_FLIGHTS_API_URL = os.getenv('AVIA_SHARED_FLIGHTS_API_URL', None)
PRICE_INDEX_HOST = os.getenv('AVIA_PRICE_INDEX_HOST', None)
AVIA_FEATURES_HOST = os.getenv('AVIA_FEATURES_HOST', None)
AVIA_STATISTICS_API_URL = os.getenv('AVIA_STATISTICS_API_URL', None)
TANKER_API_URL = os.getenv('TANKER_API_URL', 'https://tanker-api.yandex-team.ru')
TRAVEL_API_URL = os.getenv('TRAVEL_API_URL', None)
TRAVEL_API_TVM_ID = os.getenv('TRAVEL_API_TVM_ID', None)
SANDBOX_OAUTH_TOKEN = os.getenv('SANDBOX_OAUTH_TOKEN', None)
TANKER_OAUTH_TOKEN = os.getenv('TANKER_OAUTH_TOKEN', None)
YT_TOKEN = os.getenv('YT_TOKEN', None)
YT_PROXY = os.getenv('YT_PROXY', 'hahn')

AVIA_API_GATEWAY_TVM_ID = os.getenv('AVIA_API_GATEWAY_TVM_ID', None)
AVIA_API_GATEWAY_TVM_SECRET = os.getenv('TVMTOOL_LOCAL_AUTHTOKEN', os.getenv('AVIA_API_GATEWAY_TVM_SECRET', None))
TVM_FAKE = os.getenv('TVM_FAKE', False)

AVIA_FRONTEND_URL_RU = os.getenv('AVIA_FRONTEND_URL_RU', None)
TRAVEL_FRONTEND_URL_RU = os.getenv('TRAVEL_FRONTEND_URL_RU', None)
SENTRY_URL = os.getenv('AVIA_SENTRY_URL', None)
YANDEX_ENVIRONMENT_TYPE = os.getenv('YANDEX_ENVIRONMENT_TYPE', None)
DEVELOPMENT_FLAGS = os.getenv('DEVELOPMENT_FLAGS', '').split(',')

CONNECTION_TIMEOUT = float(os.getenv('AVIA_API_CONNECTION_TIMEOUT', 0.1))  # Таймаут подключения к внешемим API, сек
REQUEST_TIMEOUT = float(os.getenv('AVIA_API_REQUEST_TIMEOUT', 0.1))  # Таймаут выполнения запроса к внешним API, сек
REQUEST_ATTEMPTS = int(os.getenv('AVIA_API_REQUEST_ATTEMPTS', 3))
REQUEST_ATTEMPTS_TIMEOUT = float(os.getenv('AVIA_API_REQUEST_ATTEMPTS_TIMEOUT', 0.2))
AVIA_BACKEND_MAPS_NEAR_DIRECTIONS_CONNECTION_TIMEOUT = float(
    os.getenv('AVIA_BACKEND_MAPS_NEAR_DIRECTIONS_CONNECTION_TIMEOUT', 0.5)
)
AVIA_BACKEND_MAPS_NEAR_DIRECTIONS_REQUEST_TIMEOUT = float(
    os.getenv('AVIA_BACKEND_MAPS_NEAR_DIRECTIONS_REQUEST_TIMEOUT', 2)
)

MEMCACHED_HOST = '127.0.0.1:11211'

YT_REQUEST_LOG = os.getenv('AVIA_API_GATEWAY_YT_REQUEST_LOG', os.path.join(LOG_PATH, 'yt', 'request-{pid}.log'))
YT_RESPONSE_LOG = os.getenv('AVIA_API_GATEWAY_YT_RESPONSE_LOG', os.path.join(LOG_PATH, 'yt', 'response-{pid}.log'))

if YANDEX_ENVIRONMENT_TYPE in ('development', 'testing'):
    TANKER_BRANCH_ID = 'testing'
else:
    TANKER_BRANCH_ID = 'master'


def setup_logging():
    from raven.conf import setup_logging as raven_setup_logging
    from raven.handlers.logging import SentryHandler

    from travel.avia.library.python.error_booster.raven.unified_agent import RavenErrorBoosterUnifiedAgentClient

    dictConfig(default_config(LOG_PATH))

    error_booster_host = os.getenv('ERROR_BOOSTER_HTTP_HOST', None)
    error_booster_port = os.getenv('ERROR_BOOSTER_HTTP_PORT', None)

    if error_booster_host and error_booster_port:
        raven_client = RavenErrorBoosterUnifiedAgentClient(
            error_booster_host=error_booster_host,
            error_booster_port=error_booster_port,
            service='api-gateway',
            environment=YANDEX_ENVIRONMENT_TYPE,
            dc=CURRENT_DC,
        )
        sentry_handler = SentryHandler(raven_client)
        sentry_handler.setLevel(logging.WARNING)
        raven_setup_logging(sentry_handler)
