# -*- encoding: utf-8 -*-
import os
import logging

import tornado
import tornado.process
from tornado.ioloop import IOLoop
from tornado.httpserver import HTTPServer
from tornado.netutil import bind_unix_socket
from tornado.httpclient import AsyncHTTPClient
from tornado.options import define, options

from travel.avia.library.python.shared_objects import SharedFlag

from travel.avia.api_gateway.application.main import create_application

logger = logging.getLogger()

SOCKET_PATH = os.getenv('AVIA_TORNADO_SOCKET', '/tmp/api-gateway.sock')
WORKERS = int(os.getenv('AVIA_TORNADO_WORKERS', 1))

AsyncHTTPClient.configure('tornado.curl_httpclient.CurlAsyncHTTPClient')

define('debug', default=False, help='Debug mode')


def main():
    sockets = [bind_unix_socket(SOCKET_PATH, 0o666)]

    shutdown_flag = SharedFlag()

    if WORKERS == 1:
        application = create_application(shutdown_flag, debug=options.debug)
        server = HTTPServer(application)
        server.add_sockets(sockets)
        server.start(1)
    else:
        tornado.process.fork_processes(WORKERS)
        application = create_application(shutdown_flag, debug=options.debug)
        server = HTTPServer(application)
        server.add_sockets(sockets)

    IOLoop.current().start()


if __name__ == "__main__":
    options.parse_command_line()
    logger.info('Tornado version: {}'.format(tornado.version))
    logger.info('Debug: {}'.format(options.debug))

    main()
