PY3_LIBRARY(api_gateway)

OWNER(g:avia)

PEERDIR(
    contrib/python/Jinja2
    contrib/python/cachetools
    contrib/python/ciso8601
    contrib/python/lxml
    contrib/python/pathlib2
    contrib/python/protobuf
    contrib/python/pycurl
    contrib/python/pydantic
    contrib/python/python-memcached
    contrib/python/pytz
    contrib/python/raven
    contrib/python/requests
    contrib/python/tornado/tornado-4

    contrib/python/jaeger-client
    contrib/python/tornado-opentracing

    library/python/yt

    travel/library/python/cloud_logger
    travel/library/python/tracing/tornado_opentracing_helpers
    travel/library/python/tvm_ticket_provider

    travel/avia/api_gateway/lib/avatars

    travel/avia/library/python/enum
    travel/avia/library/python/error_booster/raven
    travel/avia/library/python/feature_flag_client
    travel/avia/library/python/iata_correction
    travel/avia/library/python/lib_yt
    travel/avia/library/python/shared_dicts
    travel/avia/library/python/shared_objects
    travel/avia/library/python/tanker
    travel/avia/library/python/urls

    travel/marketing/content/v1
)

PY_SRCS(
    application/cache/cache_root.py
    application/cache/landing_routes_cache.py
    application/cache/tanker_text_cache.py
    application/fetcher/__init__.py
    application/fetcher/anywhere_landing/fetcher.py
    application/fetcher/anywhere_landing/memcache.py
    application/fetcher/avatars/__init__.py
    application/fetcher/avia_statistics.py
    application/fetcher/backend.py
    application/fetcher/conditional_flight_fetcher.py
    application/fetcher/hotel_crosslinks.py
    application/fetcher/city_to_landing/fetcher.py
    application/fetcher/city_to_landing/mapper.py
    application/fetcher/content_backend/__init__.py
    application/fetcher/country/fetcher.py
    application/fetcher/country/types.py
    application/fetcher/country_restrictions/__init__.py
    application/fetcher/flight_supplement.py
    application/fetcher/personalization.py
    application/fetcher/price_index.py
    application/fetcher/flight_landing/enums.py
    application/fetcher/flight_landing/fetcher.py
    application/fetcher/flight_landing/mapper.py
    application/fetcher/flight_landing/terms.py
    application/fetcher/route_landing/fetcher.py
    application/fetcher/route_landing/mapper.py
    application/fetcher/personal_search/fetcher.py
    application/fetcher/personal_search/mapper.py
    application/fetcher/slugs/by_route.py
    application/fetcher/is_possible_trip/fetcher.py
    application/fetcher/shared_flights.py
    application/handlers.py
    application/main.py
    application/mapper/factory.py
    application/mapper/mail.py
    application/stat.py
    application/utils/__init__.py
    application/utils/format_time.py
    application/utils/translations.py
    application/utils/tvm.py
    application/yt_logging.py
    lib/coding.py
    lib/feature_flags.py
    lib/json.py
    lib/landings/tanker_text_cache.py
    lib/landings/templater.py
    lib/model_utils.py
    settings.py
    tornado_server.py
)

END()

RECURSE(
    bin
    lib
)

RECURSE_FOR_TESTS(tests)
