# -*- coding: utf-8 -*-
import logging

from django.core.cache import caches

from travel.avia.library.python.common.utils.memcache_backend import MemcachedCache

from travel.avia.avia_api.avia.lib.timer import Timer

log = logging.getLogger(__name__)


class LoggingMemcachedCache(MemcachedCache):
    """
    Бэкенд для memcache, логирующий времена set, get
    """

    def set(self, key, *args, **kwargs):
        timer = Timer()
        super(LoggingMemcachedCache, self).set(key, *args, **kwargs)
        log.info('set %s %s', timer.elapsed.total_seconds(), key)

    def get(self, key, *args, **kwargs):
        timer = Timer()
        result = super(LoggingMemcachedCache, self).get(key, *args, **kwargs)
        log.info('get %s %s', timer.elapsed.total_seconds(), key)
        return result


default_cache = caches['default']
shared_cache = caches['shared_cache']
