# -*- coding: utf-8 -*-
from travel.avia.library.python.avia_data.models import AmadeusMerchant
from travel.avia.library.python.common.models.partner import Partner, DohopVendor


def get_partners_by_codes(codes):
    partner_codes = []
    dohop_ids = []
    amadeus_codes = []
    partners = []

    for c in codes:
        if c.startswith('dohop_'):
            try:
                dohop_ids.append(int(c.replace('dohop_', '')))
            except ValueError:
                continue
        elif c.startswith('amadeus_'):
            amadeus_codes.append(c)
        else:
            partner_codes.append(c)

    if partner_codes:
        partners += [p for p in Partner.objects.filter(code__in=partner_codes)]

    if dohop_ids:
        partners += [v for v in DohopVendor.objects.filter(dohop_id__in=dohop_ids)]

    if amadeus_codes:
        partners += [v for v in AmadeusMerchant.objects.filter(code__in=amadeus_codes)]

    return partners


def get_partner_by_code(code):
    partners = get_partners_by_codes([code])
    try:
        return partners[0]
    except IndexError:
        return None
