# -*- coding: utf-8 -*-
from django.db import models
from django.db.models import fields
from django.utils.translation import ugettext_lazy as _

from travel.avia.library.python.common.models.partner import Partner


class QueryBlackList(models.Model):
    CLASS_CHOICES = [
        (u'economy', _(u'Эконом')),
        (u'business', _(u'Бизнес')),
        (u'first', _(u'Первый')),
    ]

    partner = models.ForeignKey(
        Partner, null=True, blank=True, verbose_name=_(u"партнер")
    )

    country_from = models.ForeignKey(
        'www.Country', null=True, blank=True,
        related_name=u"query_black_list_country_from",
        verbose_name=_(u"страна отправления")
    )

    settlement_from = models.ForeignKey(
        'www.Settlement', null=True, blank=True,
        related_name=u"query_black_list_settlement_from",
        verbose_name=_(u"город отправления")
    )

    station_from = models.ForeignKey(
        'www.Station', null=True, blank=True,
        related_name=u"query_black_list_station_from",
        verbose_name=_(u"станция отправления")
    )

    country_to = models.ForeignKey(
        'www.Country', null=True, blank=True,
        related_name=u"query_black_list_country_to",
        verbose_name=_(u"страна прибытия")
    )

    settlement_to = models.ForeignKey(
        'www.Settlement', null=True, blank=True,
        related_name=u"query_black_list_settlement_to",
        verbose_name=_(u"город прибытия")
    )

    station_to = models.ForeignKey(
        'www.Station', null=True, blank=True,
        related_name=u"query_black_list_station_to",
        verbose_name=_(u"станция прибытия")
    )

    company = models.ForeignKey(
        'www.Company', null=True, blank=True,
        related_name=u"query_black_list_company",
        verbose_name=_(u"Перевозчик")
    )

    flight_number = fields.CharField(
        _(u'Номер рейса'), null=True, blank=True, max_length=10, db_index=True
    )

    when_from = fields.DateField(
        _(u'Дата рейса от'), null=True, blank=True, db_index=True
    )

    when_to = fields.DateField(
        _(u'Дата рейса до'), null=True, blank=True, db_index=True
    )

    price_from = models.FloatField(_(u'Цена от'), blank=True, null=True)

    price_to = models.FloatField(_(u'Цена до'), blank=True, null=True)

    currency = models.ForeignKey(
        'currency.Currency', null=True, blank=True,
        related_name=u"query_black_list_price_currency",
        verbose_name=_(u"Валюта")
    )

    klass = models.CharField(
        _(u'Класс'), choices=CLASS_CHOICES, null=True, blank=True, max_length=10
    )

    description = fields.CharField(
        _(u'Причина бана'), null=False, blank=False, max_length=255
    )

    active_to = fields.DateField(
        _(u'Активно до'), null=False, blank=False, db_index=True
    )

    active = fields.BooleanField(
        _(u'Активно'), null=False, blank=False, db_index=True
    )

    def __unicode__(self):
        return _(u"Правило № %s") % self.id

    class Meta:
        app_label = 'order'
        verbose_name = _(u"правило черного списка")
        verbose_name_plural = _(u"правила черного списка")
