# -*- coding: utf-8 -*-
import logging
import sys
import traceback
import urllib
from urlparse import urlsplit, urlunsplit

from django.core.mail import mail_managers
from django.utils.encoding import smart_unicode

from travel.avia.avia_api.avia.api.model_utils import get_partner_by_code

log = logging.getLogger(__name__)


def url_add_openstat_marker(url, partner_code, host, domain):
    if partner_code in ['glavbilet', 'ufs', 'tickets_ua']:
        return url

    if partner_code.startswith('dohop'):
        return url

    o = urlsplit(url)

    marker = u"ticket.yandex.%s;%s;Купить Авиабилет;%s" % \
        (domain, partner_code, host)

    query = (o.query + '&' if o.query else '') + \
        '_openstat=' + urllib.quote(marker.encode('utf-8'), safe='')

    return urlunsplit((o.scheme, o.netloc, o.path, query, o.fragment))


def get_redirect_partner(order_data):
    partner = get_partner_by_code(order_data['partner'])

    if not partner:
        raise RedirectError('No partner')

    if not partner.enabled:
        raise RedirectError('Not partner.enabled [%s]', partner.code)

    return partner


class RedirectError(Exception):
    pass


class DaemonApiError(Exception):
    pass


def _get_user_info_from_django_request(request):
    django_user = request.yauser.get_django_user()

    user_info = {
        'REMOTE_ADDR': request.META.get('REMOTE_ADDR'),
        'cookies': {
            'yandex_gid': request.COOKIES.get('yandex_gid'),
            'yandexuid': request.COOKIES.get('yandexuid'),
            'yandex_login': request.COOKIES.get('yandex_login'),
        }
    }

    if request.yauser.is_authenticated():
        user_info.update({
            'yauser': {
                'uid': request.yauser.uid,
                'login': request.yauser.fields.get('login'),
            },
            'django_user': {
                'username': django_user.username,
                'is_staff': django_user.is_staff,
            },
        })

    return user_info


def mail_error(e):
    exception, value, tb = sys.exc_info()
    lines = traceback.format_exception(exception, value, tb)
    try:
        value_str = ', '.join(value)
    except (TypeError, AttributeError):  # happens for non-iterable values
        value_str = unicode(value)

    message = u'%-20s %s' % (exception.__name__, value_str)
    message += u"\n" + u'\n'.join([smart_unicode(l) for l in lines])
    mail_managers(u"Rasp: Ошибка при переходе к партнеру", message, fail_silently=True)


class RedirectData(object):
    def __init__(self, url, post=None, m_url=None):
        self.url = url
        self.post = post
        self.m_url = m_url

    def __json__(self):
        return {
            'url': self.url,
            'post': self.post,
        }
