# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from flask import request
from logging import getLogger

try:
    from django.db import close_old_connections as close_connection
except ImportError:
    from django.db import close_connection
from django.db import reset_queries
from django.conf import settings

from travel.avia.avia_api.avia.health import available_ping_checks, HealthError
from travel.avia.avia_api.avia.middleware.environ_now import EnvironNow
from travel.avia.avia_api.avia.middleware.http_schema_proxy import HTTPSchemaProxy

log = getLogger(__name__)


def configure_app(app, config=None):
    app.config['MONGODB_SETTINGS'] = settings.MONGODB_SETTINGS

    if config:
        app.config.update(config)

    app.wsgi_app = HTTPSchemaProxy(app.wsgi_app)
    app.wsgi_app = EnvironNow(app.wsgi_app)

    app.secret_key = 'gJ0auW!X+uUV W/kR?8,3GSi~nruB1'
    app.debug = settings.FLASK_DEBUG

    from travel.avia.avia_api.avia.v1.model.db import db
    db.init_app(app)

    @app.route('/ping', methods=['GET'])
    def ping():
        try:
            for check in available_ping_checks:
                if request.args.get(check.disable_flag) is None:
                    check.checker.check()
        except HealthError as e:
            log.warn(e, exc_info=True)
            return 'error', 503
        except Exception:
            log.exception('ping backend exception')
            return 'error', 500

        return 'ok', 200

    app.before_request(lambda *_args, **_kwargs: reset_queries())
    app.teardown_request(lambda *_args, **_kwargs: close_connection())

    return app
