from logging import getLogger

from travel.avia.library.python.common.models.schedule import Company

log = getLogger(__name__)


class CompanyCache(object):
    def __init__(self):
        self._by_id = {}

    def precache(self):
        companies = tuple(Company.objects.all())

        self._by_id = {company.id: company for company in companies}

        try:
            self._fallback = next(
                company
                for company in companies
                if company.short_title == '#### avia-api fallback ####'
            )
        except Exception as exc:
            self._fallback = None
            log.critical('No fallback company is found (%r)', exc)

    def by_id(self, company_id):
        return self._by_id.get(company_id)

    def fallback(self):
        return self._fallback


company_cache = CompanyCache()
