# -*- coding: utf-8 -*-
from collections import defaultdict
from logging import getLogger

from django.conf import settings

log = getLogger(__name__)


def hahn_client():
    import yt.wrapper as yt
    yt.config['proxy']['url'] = 'hahn.yt.yandex.net'
    yt.config['token'] = settings.YT_TOKEN
    yt.config['read_retries']['enable'] = True
    yt.config['clear_local_temp_files'] = True
    return yt


class DynamicsCache(object):
    def __init__(self, yt_wrapper):
        self._yt = yt_wrapper

    def precache(self):
        table = defaultdict(lambda: defaultdict(dict))
        for row in self._yt.read_table(
            table='//home/rasp/sovetnik_stat/from_now_2016_by_month',
            format=self._yt.JsonFormat(),
        ):
            table[
                row['object_from_id'],  # point_key
                row['object_to_id'],  # point_key
                row['month']  # 1-12
            ][
                row['year']
            ][
                row['search_year'],
                row['search_month'],  # 1-12
            ] = row['p5_price']

        self._table = table

    def min_price(
        self, from_point, to_point, now_year, now_month, year, month,
        currency_code,
    ):
        if currency_code != 'RUR':
            return None  # В YT хранится рублёвая динамика

        prices = self._table[from_point, to_point, month]
        if not prices:
            return None

        try:
            nearest_year = max(y for y in prices if y <= year)
        except Exception:  # no such year
            log.warning('Year %r passed. We only have %s', year, prices.keys())
            return None

        year_prices = prices[nearest_year]

        def distance(from_year, from_month, to_year, to_month):
            return 12 * (to_year - from_year) + (to_month - from_month)

        needed_distance = distance(now_year, now_month, year, month)

        nearest_dates = min(
            year_prices, key=lambda (search_year, search_month): abs(
                needed_distance - distance(
                    search_year, search_month, nearest_year, month
                )
            )
        )
        return year_prices[nearest_dates]


dynamics_cache = DynamicsCache(hahn_client())
