from travel.avia.library.python.avia_data.models import AmadeusMerchant
from travel.avia.library.python.common.models.partner import Partner, DohopVendor


class PartnerCache(object):
    def __init__(self):
        self._by_code = {}

    def precache(self):
        self._by_code = {
            partner.code: partner
            for partner in (
                tuple(Partner.objects.all()) +
                tuple(DohopVendor.objects.all()) +
                tuple(AmadeusMerchant.objects.all())
            )
        }

    def by_code(self, partner_code):
        return self._by_code.get(partner_code)


partner_cache = PartnerCache()
