from logging import getLogger

from travel.avia.library.python.avia_data.models import TopFlight

log = getLogger(__name__)


class TopFlightsCache(object):
    def __init__(self):
        self._redirects = {}

    def precache(self):
        top_flights = list(TopFlight.objects.values_list(
            'from_point_key', 'to_point_key', 'day_of_week', 'flights',
            'redirects'
        ))
        top_flights.sort(key=lambda tf: tf[-1])
        self._redirects = {tf[:-1]: tf[-1] for tf in top_flights}

    def get(self, trip):
        """

        :type trip: avia.http_api_schemas.Trip
        :rtype: int
        """
        if (
            trip.segments and
            trip.start_station().settlement and
            trip.end_station().settlement
        ):
            key = (
                trip.start_station().settlement.point_key,
                trip.end_station().settlement.point_key,
                trip.starts_at().weekday(),
                trip.key().replace('-', ';')
            )
            return self._redirects.get(key, 0)
        return 0


popularity_cache = TopFlightsCache()
