# -*- coding: utf-8 -*-
import logging
from collections import namedtuple

from travel.avia.avia_api.avia.api.caches import default_cache, shared_cache
from travel.avia.avia_api.local_settings import CACHE_REDIS, MAXIMUM_LAG
from travel.avia.library.python.redis.ping import RedisChecker, SharedCacheChecker

logger = logging.getLogger(__name__)

PingCheckInfo = namedtuple('PingCheckInfo', ('disable_flag', 'checker'))


class HealthError(Exception):
    def __init__(self, message):
        self.message = message

    def __str__(self):
        return '<{} message={}/>'.format(
            self.__class__.__name__,
            self.message
        )


available_ping_checks = [
    PingCheckInfo('disable-shared-cache-check', SharedCacheChecker('avia-api', shared_cache))
]

if CACHE_REDIS:
    available_ping_checks.append(PingCheckInfo('disable-redis-check', RedisChecker(default_cache, MAXIMUM_LAG)))
