# -*- coding: utf-8 -*-
import logging
from datetime import date, datetime

from flask.json import JSONEncoder
from bson.objectid import ObjectId

log = logging.getLogger(__name__)


class ApiJSONEncoder(JSONEncoder):
    def __init__(self, *args, **kwargs):
        log.debug('ApiJSONEncoder __init__ kwargs: %s', kwargs)
        kwargs.update({
            'ensure_ascii': True,
            'sort_keys': False,
            'indent': None,
            'separators': (',', ':'),
        })
        super(ApiJSONEncoder, self).__init__(*args, **kwargs)

    def default(self, obj):
        try:
            if hasattr(obj, '__json__'):
                return obj.__json__()

            if isinstance(obj, datetime):
                if obj.tzinfo:
                    return obj.strftime('%Y-%m-%d %H:%M:%S %z')

                else:
                    return obj.strftime('%Y-%m-%d %H:%M:%S')

            if isinstance(obj, date):
                return obj.strftime('%Y-%m-%d')

            if isinstance(obj, ObjectId):
                return str(obj)

            iterable = iter(obj)

        except TypeError:
            pass

        else:
            return list(iterable)

        return JSONEncoder.default(self, obj)
