# -*- coding: utf-8 -*-
import os

import codecs
import json
import logging

from travel.avia.avia_api.avia.lib.date import modification_datetime


log = logging.getLogger(__name__)


class JsonFileCache(object):
    def __init__(self, filename):
        self.filename = filename

    def exists(self):
        return os.path.exists(self.filename)

    @property
    def last_modified_at(self):
        try:
            return modification_datetime(self.filename).replace(microsecond=0)
        except Exception as exc:
            log.exception(
                "Couldn't get a modification datetime of %r: %r",
                self.filename, exc
            )
            return None

    def save(self, data):
        log.info('Updating cache in %r', self.filename)

        try:
            with codecs.open(self.filename, 'w', 'utf-8') as f:
                json.dump(data, f, ensure_ascii=False)
        except Exception as exc:
            log.exception(
                "Couldn't save new cache into %r: %r", self.filename, exc
            )
        else:
            log.info('Saved new cache into %r', self.filename)

    def load(self):
        try:
            with codecs.open(self.filename, 'r', 'utf-8') as f:
                return json.load(f)
        except Exception as exc:
            log.exception(
                "Couldn't load cache from %r: %r", self.filename, exc
            )
