# -*- coding: utf-8 -*-
class DictProxyDescriptor(object):
    def __init__(self, container, key):
        self._container = container
        self._key = key

    def __get__(self, obj, objtype):
        return self._container.get(self._key)

    def __set__(self, obj, val):
        self._container[self._key] = val
