# -*- coding: utf-8 -*-
import logging

import feature_flag_client

from travel.avia.avia_api.avia.settings import env_variable_provider


__feature_flags_client = feature_flag_client.Client(
    host=env_variable_provider.get('FEATURE_FLAG_HOST', required=False),
    service_code='avia_api',
    logger=logging.getLogger('feature_flag_client')
)

storage = feature_flag_client.Storage(__feature_flags_client)


def sovetnik_travel_search_switch():
    """
    RASPTICKETS-17535 Переключение трафика: советник
    Подменяем ссылки на портальную страницу /search
    :return bool:
    """
    return storage.flag_enabled('SOVETNIK_TRAVEL_SEARCH_SWITCH')


def sovetnik_travel_redirect_switch():
    """
    RASPTICKETS-17535 Переключение трафика: советник
    Подменяем ссылки на портальную страницу /order/redirect
    :return bool:
    """
    return storage.flag_enabled('SOVETNIK_TRAVEL_REDIRECT_SWITCH')


def use_travel_portal_links(national_version):
    """
    https://st.yandex-team.ru/RASPTICKETS-20059
    Меняем ссылки: портал вместо старого авиа для ru
    :return bool:
    """
    return national_version == 'ru'
