from functools import wraps

from flask import request

from travel.avia.avia_api.avia.lib import authdigest


class FlaskRealmDigestDB(authdigest.RealmDigestDB):
    def __init__(self, realm, algorithm='md5', users=None):
        super(FlaskRealmDigestDB, self).__init__(realm, algorithm)
        if users:
            for username, password in users:
                self.add_user(username, password)

    def requires_auth(self, fn):
        @wraps(fn)
        def decorated(*args, **kwargs):
            if not self.is_authenticated(request):
                return self.challenge()

            return fn(*args, **kwargs)

        return decorated
