# -*- coding: utf-8 -*-
from collections import OrderedDict

from flask import jsonify


class Jsend(OrderedDict):
    def get_response(self):
        response = jsonify(self)
        response.headers['Content-type'] = 'application/json; charset=utf-8'

        # security headers
        response.headers.add('X-Frame-Options', 'SAMEORIGIN')
        response.headers.add('X-XSS-Protection', '1; mode=block')
        response.headers.add('X-Content-Type-Options', 'nosniff')

        response.status_code = self.status_code
        return response


class BaseJsend(Jsend):
    def __init__(self, status_code, **kwargs):
        super(BaseJsend, self).__init__()
        self.status_code = status_code
        self.update(kwargs)


class JsendSuccess(Jsend):
    status_code = 200

    def __init__(self, data):
        super(JsendSuccess, self).__init__()
        self['status'] = 'success'
        self['data'] = data


class JsendFail(Jsend):
    status_code = 400

    def __init__(self, data, status_code=None):
        if status_code is not None:
            self.status_code = status_code

        super(JsendFail, self).__init__()
        self['status'] = 'fail'
        self['data'] = data


class JsendError(Jsend):
    status_code = 500

    def __init__(self, message):
        super(JsendError, self).__init__()
        self['status'] = 'error'
        self['message'] = message


class ApiFail(Exception):
    def __init__(self, data, status_code=400):
        super(ApiFail, self).__init__(self)
        self.data = data
        self.status_code = status_code

    def get_response(self):
        response = self.jsend.get_response()
        response.status_code = self.status_code

        return response

    @property
    def jsend(self):
        return JsendFail(self.data)
