# -*- coding: utf-8 -*-


def iterate_chunks(mongo_model_class, primary_key_name, mongo_queryset, chunk_size=2000):
    """
    Iterate large mongo collection in chunks.

    Example usage:

    iterate_chunks(Subscriber, 'id', Subscriber.objects.all())

    iterate_chunks(Subscriber, 'id', Subscriber.objects.filter(email__endswith='dex.ru'))

    iterate_chunks(Subscription, 'qkey', Subscription.objects)

    :param type[mongoengine.Document] | mongoengine.Document mongo_model_class: example: User , Subscriber, Subscription
    :param basestring primary_key_name: name of document's primary key, like 'id', 'qkey', etc...
    :param mongoengine.queryset.QuerySet mongo_queryset: example: User.objects.all() or User.objects.filter(name='Vasily')
    :param int chunk_size: default 2000
    """
    assert (' ' not in primary_key_name)
    ids = tuple(
        mongo_queryset.values_list(primary_key_name)
    )
    for i in range(0, len(ids), chunk_size):
        ids_chunk = ids[i:i + chunk_size]
        filter_query = {primary_key_name + '__in': ids_chunk}
        for instance in mongo_model_class.objects.filter(**filter_query).no_cache():
            yield instance
