# -*- coding: utf-8 -*-
from flask import current_app
from flask.sessions import SecureCookieSessionInterface, SecureCookieSession
from itsdangerous import BadSignature


class AviaSecureCookieSession(SecureCookieSession):
    def get_xsession_value(self):
        app = current_app
        interface = app.session_interface
        serializer = interface.get_signing_serializer(app)
        session_dict = dict(self)
        return serializer.dumps(session_dict)


class AviaSessionInterface(SecureCookieSessionInterface):
    """ Allows the transfer of a session through the X-SESSION header """

    session_class = AviaSecureCookieSession

    def open_session(self, app, request):
        session = (
            self.open_header_session(app, request) or
            super(AviaSessionInterface, self).open_session(app, request)
        )

        return session

    def open_header_session(self, app, request):
        val = request.headers.get('X-SESSION')

        if not val:
            return None

        s = self.get_signing_serializer(app)

        if s is None:
            return None

        try:
            data = s.loads(val)
            return self.session_class(data)

        except BadSignature:
            return None
