# -*- coding: utf-8 -*-
from datetime import datetime, timedelta


class Timer(object):
    def __init__(self):
        self.start_time = datetime.now()

    @property
    def elapsed(self):
        return datetime.now() - self.start_time

    def get_elapsed_seconds(self):
        return self.elapsed.total_seconds()

    def seconds_to_delta(self, delta):
        return (delta - self.elapsed).total_seconds()

    def seconds_to_shift(self, shift):
        return self.seconds_to_delta(timedelta(seconds=shift))
