# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging

from django.conf import settings

from travel.avia.avia_api.avia.lib.currency import CurrencyRatesInfoStorage, Price

log = logging.getLogger(__name__)


FOREIGN_CURRENCY_COEFF = 1.03


def convert_tariffs_to_currency(variants, national_version, currency):
    rates = CurrencyRatesInfoStorage().info(national_version).rates()

    if currency is None:
        log.error('No currency is given for %r', national_version)
        currency = settings.NATIONAL_CURRENCIES.get(national_version)

    good_variants = []
    for variant in variants:
        if variant.tariff.currency == currency:
            variant.national_tariff = variant.tariff
        else:
            try:
                variant.national_tariff = Price(
                    value=(
                        float(variant.tariff.value) *
                        rates[variant.tariff.currency] /
                        rates[currency]
                    ),
                    currency=currency
                ) * FOREIGN_CURRENCY_COEFF
            except (ValueError, KeyError) as exc:
                log.warning(
                    "Couldn't convert tariff to national currency [%s]: %s",
                    national_version, exc
                )
                continue

        good_variants.append(variant)

    return good_variants
