# -*- coding: utf-8 -*-
import logging
import time
from enum import Enum

import ujson

from travel.avia.avia_api.avia.lib.yt_loggers.yt_log import validate_schema

email_yt_logger = logging.getLogger('yt.subscriptions.email_sent')
log = logging.getLogger(__name__)


class EmailType(Enum):
    CONFIRM_1_OPT = '1_opt_in'
    CONFIRM_2_OPT = '2_opt_in'
    PRICE_CHANGE_PART = 'price_change_part'


email_log_schema = dict(
    unixtime=dict(type=int, lf_type='VT_UINT64', required=True),
    email_type=dict(type=EmailType, lf_type='VT_STRING', required=True),
    email=dict(type=basestring, lf_type='VT_STRING', required=True),
    qkey=dict(type=basestring, lf_type='VT_STRING', required=True),
    date_range=dict(type=int, lf_type='VT_UINT64', required=False),
    filter_params=dict(type=dict, lf_type='VT_ANY', required=False),
    source=dict(type=basestring, lf_type='VT_STRING', required=False),
    email_content=dict(type=dict, lf_type='VT_ANY', required=True),
)


def log_email(**kwargs):
    """
    :param kwargs: logging data according to email_log_schema
    """
    try:
        kwargs.update(dict(unixtime=int(time.time())))
        validate_schema(kwargs, email_log_schema)
        email_yt_logger.info('%s', ujson.dumps(kwargs))
    except (KeyError, ValueError, TypeError):
        log.exception('Cannot log data %s', kwargs)


def log_1_opt_in_email_sent(email=None, qkey=None, email_content=None):
    """
    :param str email:
    :param str qkey:
    :param dict email_content:
    :return:
    """
    log_email(
        email_type=EmailType.CONFIRM_1_OPT,
        email=email,
        qkey=qkey,
        email_content=email_content,
    )


def log_2_opt_in_email_sent(email=None, qkey=None, email_content=None):
    """
    :param str email:
    :param str qkey:
    :param dict email_content:
    :return:
    """
    log_email(
        email_type=EmailType.CONFIRM_2_OPT,
        email=email,
        qkey=qkey,
        email_content=email_content,
    )


def log_price_change_email_part(
    email=None, qkey=None, date_range=None, filter_params=None, email_content=None
):
    """
    :param str email:
    :param str qkey:
    :param int date_range:
    :param dict filter_params:
    :param dict email_content:
    :return:
    """
    log_email(
        email_type=EmailType.PRICE_CHANGE_PART,
        email=email,
        qkey=qkey,
        date_range=date_range,
        filter_params=filter_params,
        email_content=email_content,
    )
