# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging
import time
from contextlib import contextmanager

from django.conf import settings

log = logging.getLogger(__name__)


class BigRuntimeMeasurer(object):
    @contextmanager
    def measure(self):
        timestamp = time.time()
        yield
        run_time = time.time() - timestamp

        if run_time > settings.MIDDLEWARE_EXCESS_TIMING_LIMIT:
            log.warning(
                '%s excess timing: %0.4f', type(self).__name__, run_time
            )


class WsgiMiddleware(BigRuntimeMeasurer):
    def __init__(self, app):
        self._app = app
        super(WsgiMiddleware, self).__init__()

    def __call__(self, environ, start_response):
        return self._app(environ, start_response)
