# -*- coding: utf-8 -*-
import logging

from django.core import signals
from django.core.handlers import base
from django.core.handlers.wsgi import WSGIHandler
from django.core.urlresolvers import set_script_prefix

from travel.avia.avia_api.avia.middleware.base import WsgiMiddleware

log = logging.getLogger(__name__)


class DjangoRequestMiddleware(WsgiMiddleware, WSGIHandler):
    """
    Создаёт django-request и кладёт его в environ
    """
    def __init__(self, app):
        super(DjangoRequestMiddleware, self).__init__(app)

    def __call__(self, environ, start_response):
        with self.measure():
            self.process_environ(environ)

        return super(DjangoRequestMiddleware, self).__call__(
            environ, start_response
        )

    def process_environ(self, environ):
        # Set up middleware if needed. We couldn't do this earlier, because
        # settings weren't available.
        if self._request_middleware is None:
            self.initLock.acquire()
            try:
                try:
                    # Check that middleware is still uninitialised.
                    if self._request_middleware is None:
                        self.load_middleware()
                except:
                    # Unload whatever middleware we got
                    self._request_middleware = None
                    raise
            finally:
                self.initLock.release()

        set_script_prefix(base.get_script_name(environ))
        signals.request_started.send(sender=self.__class__)
        try:
            try:
                environ['django_request'] = self.request_class(environ)
            except UnicodeDecodeError:
                log.warning('Bad Request (UnicodeDecodeError)', exc_info=True, extra={'status_code': 400})
        finally:
            signals.request_finished.send(sender=self.__class__)
