from datetime import datetime

from travel.avia.library.python.common.utils.date import MSK_TZ

from travel.avia.avia_api.avia.middleware.base import WsgiMiddleware


class EnvironNow(WsgiMiddleware):
    def __call__(self, environ, start_response):
        with self.measure():
            now = datetime.now()
            environ['now'] = environ['msk_now'] = MSK_TZ.localize(now)
            environ['naive_msk_now'] = environ['msk_now'].replace(tzinfo=None)

        return super(EnvironNow, self).__call__(environ, start_response)
