from travel.avia.avia_api.avia.middleware.base import WsgiMiddleware


class HTTPSchemaProxy(WsgiMiddleware):
    def __call__(self, environ, start_response):
        with self.measure():
            scheme = environ.get('HTTP_X_FORWARDED_PROTOCOL', '')
            if scheme:
                environ['wsgi.url_scheme'] = scheme

        return super(HTTPSchemaProxy, self).__call__(environ, start_response)
