# -*- coding: utf-8 -*-
from travel.avia.library.python.avia_data.settings import *

from travel.avia.avia_api.avia.settings.general import *

PROJECT_CODE = 'api_avia'

DAEMON_API_TIMEOUT = 5.5  # daemon http api

MIGRATIONS_PATH = '/app/mongomigrations/'
MIGRATIONS_COLLECTION = 'migrations'
MIGRATION_LOCKS_COLLECTION = 'locks'

LOG_PATH = os.getenv('AVIA_LOG_PATH', './log')

SHOW_LOG = '/var/log/yandex/ticket/order/show.log'
DOUBLING_SHOW_LOG = os.path.join(LOG_PATH, 'yt', 'doubling', 'show.log')

YT_SEARCH_LOG_PATH = os.path.join(LOG_PATH, 'yt', 'users-search-form.log')
YT_REDIR_LOG_PATH = os.path.join(LOG_PATH, 'yt', 'popular_flights.log')


IGNORE_DAEMON_CACHE = False

NATIONAL_VERSIONS = AVIA_NATIONAL_VERSIONS = ['ru', 'ua', 'kz', 'tr', 'com']

NATIONAL_VERSIONS_CAPITAL_GEOID = {
    'ru': 213,  # Москва
    'ua': 143,  # Киев
    'kz': 163,  # Астана
    'tr': 11508,  # Стамбул
    'com': 10393,  # Лондон
}

AVIA_API_LANGUAGES = ['ru', 'uk', 'tr', 'en', 'de']
TRANSLATED_LANGUAGES_MAPPING = {  # Переводы из танкера
    'ru': 'ru',
    'uk': 'uk',
    'tr': 'tr',
    'en': 'en',
}

XGETTEXT_LANGUAGES = ['en', 'ru', 'uk', 'be', 'tt', 'kk', 'tr', 'de']

MIDDLEWARE_EXCESS_TIMING_LIMIT = 0.2


def with_suffix(suffix, prefixes):
    return [prefix + suffix for prefix in prefixes]


PRECACHE = with_suffix('.objects.precache', [
    'travel.avia.library.python.common.models.geo:StationType',
    'travel.avia.library.python.common.models.geo:StationMajority',
    'travel.avia.library.python.common.models.geo:StationTerminal',
    'travel.avia.library.python.common.models.geo:Country',
    'travel.avia.library.python.common.models.geo:Region',
    'travel.avia.library.python.common.models.geo:Settlement',
    'travel.avia.library.python.common.models.geo:CodeSystem',
    'travel.avia.library.python.common.models.schedule:Company',
    'travel.avia.library.python.common.models.transport:TransportType',
    'travel.avia.library.python.common.models.transport:TransportModel',
]) + [
    'travel.avia.avia_api.avia.cache.top_flights:popularity_cache.precache',
    'travel.avia.avia_api.avia.cache.companies:company_cache.precache',
    'travel.avia.avia_api.avia.cache.partners:partner_cache.precache',
    'travel.avia.avia_api.avia.cache.stations:station_cache.precache',
    'travel.avia.avia_api.avia.cache.stations:airport_cache.precache',
    'travel.avia.avia_api.avia.cache.settlements:settlement_cache.precache',
    'travel.avia.avia_api.avia.cache.settlements:avia_settlement_cache.precache',
    'travel.avia.avia_api.avia.cache.dynamics:dynamics_cache.precache',
    'travel.avia.library.python.common.cache.substitutions:substitution_cache.precache',
]

DELAY_BEFORE_RETRY_AFTER_EMPTY_VARIANTS = 1.0

ALLOW_GEOBASE = True
